#include "dbmonitor/dbunix.h"
#include "dbmonitor/dbhost.h"

class UnixWd : public PadRcv {
	int	fd, bd;
	long	key;
	Pad	*pad;
	char	*wd;
	char	*prevwd;
	Index	ix;
	Index	carte();
	char	*getwd();
	void	pwd(Attrib=0);
	char	*kbd(char *);
	char	*help(long);
public:
		UnixWd(int,int);
	void	open();
};

class UnixMaster : public RtMaster {
protected:
	UnixWd	wd;
	char	*dopscmd(int);
	char	*kbd(char*);
	char	*help(long);
	void	open();
	void	refresh(int);
	void	wdopen();
	Process	*newProcess(Process*,char*,char*,char*);
public:
	UnixMaster(int,int,int,RtNode*);
};

class UnixProcess : public Process {
	friend UnixCore;
protected:
	int	fd;
	int	boardid;
	int	pipeid;
	SigMask	*sigmsk;

	int	accept(Action);
	Index	carte();
	void	destroy();
	int	fixsymtab();
	void	hang();
	void	hangopen();
	void	hangtakeover();
	void	imprint();
	void	opensigmask();
	void	stop();
	void	substitute(UnixProcess*);
	void	takeover();
	void	userclose();
	Core	*newCore(Master*);
public:
		UnixProcess(int,int,int,Process*,char*,char*,char*);
	void	open(long);
};

class UnixCore : virtual public Core {
	friend UnixProcess;
protected:
	int		commfd;
	int		boardid;
	int		procid;
	int		pipeid;
	Unixconfig	config;
	Unixstate	state;

	int	atsyscall();
	Behavs	behavetype();
	char	*dbreq(int, char* =0, int =0, int =0);
	char	*dostep(long,long,int);
	char	*exechang(long);
	int	exechangsupported();
	int	nsig();
	char	*readwrite(long,char*,int,int);
	long	regaddr();
	char	*resources();	
	long	scratchaddr();
	char	*signalclear();
	char	*signalmask(long);
	long	signalmaskinit();
	char	*signalname(long);
	char	*signalsend(long);
public:
		UnixCore(int,int,int);
	Behavs	behavs();
	void	close();
	char	*destroy();
	char	*eventname();
	char	*laybpt(Trap*);
	char	*open();
	char	*problem();
	char	*reopen(char*,char*);
	char	*run();
	char	*stop();
};
